import os
import django
from channels.routing import ProtocolTypeRouter, URLRouter
from channels.auth import AuthMiddlewareStack
from django.core.asgi import get_asgi_application
from website import routing as website_routing

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "ovosolutions.settings")
django.setup()

application = ProtocolTypeRouter({
    "http": get_asgi_application(),
    "websocket": AuthMiddlewareStack(
        URLRouter(website_routing.websocket_urlpatterns)
    ),
})
