import json
from channels.generic.websocket import AsyncWebsocketConsumer
from asgiref.sync import async_to_sync

class DashboardConsumer(AsyncWebsocketConsumer):
    """
    Handles real-time data updates between backend and frontend dashboard.
    """

    async def connect(self):
        await self.channel_layer.group_add("dashboard_updates", self.channel_name)
        await self.accept()
        await self.send(text_data=json.dumps({"status": "connected"}))

    async def disconnect(self, close_code):
        await self.channel_layer.group_discard("dashboard_updates", self.channel_name)

    async def receive(self, text_data):
        data = json.loads(text_data)
        print(f"Received from frontend: {data}")

    async def send_update(self, event):
        """Send updates triggered by Django signals."""
        await self.send(text_data=json.dumps(event["data"]))
