# Generated by Django 5.2.7 on 2025-10-31 20:20

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('website', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source', models.CharField(choices=[('post', 'Post'), ('event', 'Event'), ('training', 'Training'), ('file', 'File'), ('manual', 'Manual')], default='manual', max_length=50)),
                ('source_id', models.CharField(blank=True, max_length=200, null=True)),
                ('title', models.CharField(blank=True, max_length=400)),
                ('text', models.TextField()),
                ('chunk_index', models.IntegerField(default=0)),
                ('embedding_dim', models.IntegerField(blank=True, null=True)),
                ('embedding_vector', models.JSONField(blank=True, default=list)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.AddField(
            model_name='event',
            name='organizer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='status',
            field=models.CharField(choices=[('Pending', 'Pending'), ('Reviewed', 'Reviewed'), ('Shortlisted', 'Shortlisted'), ('Rejected', 'Rejected')], default='Pending', max_length=50),
        ),
        migrations.CreateModel(
            name='ConversationLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user_identifier', models.CharField(blank=True, max_length=200, null=True)),
                ('user_message', models.TextField()),
                ('bot_reply', models.TextField()),
                ('intent', models.CharField(blank=True, max_length=100, null=True)),
                ('sources', models.JSONField(blank=True, default=list)),
                ('confidence', models.FloatField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='AssistantFeedback',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('helpful', models.BooleanField(null=True)),
                ('comment', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('conversation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='website.conversationlog')),
            ],
        ),
    ]
