# Generated by Django 5.2.7 on 2025-11-08 19:52

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('website', '0004_blovionpost'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(default='Uncategorized', max_length=100)),
                ('slug', models.SlugField(unique=True)),
                ('description', models.TextField(blank=True, default='')),
                ('color', models.CharField(default='#3B82F6', help_text='Hex color code', max_length=7)),
                ('is_active', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name_plural': 'Categories',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SystemMetric',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metric_type', models.CharField(default='unknown', max_length=100)),
                ('value', models.FloatField(default=0.0)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('recorded_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                'verbose_name': 'System Metric',
                'verbose_name_plural': 'System Metrics',
                'ordering': ['-recorded_at'],
            },
        ),
        migrations.AlterModelOptions(
            name='assistantfeedback',
            options={'verbose_name': 'Assistant Feedback', 'verbose_name_plural': 'Assistant Feedback'},
        ),
        migrations.AlterModelOptions(
            name='blovionpost',
            options={'ordering': ['-published_at', '-created_at'], 'verbose_name': 'Blovion Post', 'verbose_name_plural': 'Blovion Posts'},
        ),
        migrations.AlterModelOptions(
            name='contact',
            options={'ordering': ['-created_at'], 'verbose_name': 'Contact Submission', 'verbose_name_plural': 'Contact Submissions'},
        ),
        migrations.AlterModelOptions(
            name='conversationlog',
            options={'ordering': ['-created_at'], 'verbose_name': 'Conversation Log', 'verbose_name_plural': 'Conversation Logs'},
        ),
        migrations.AlterModelOptions(
            name='document',
            options={'ordering': ['source', 'chunk_index'], 'verbose_name': 'AI Document', 'verbose_name_plural': 'AI Documents'},
        ),
        migrations.AlterModelOptions(
            name='event',
            options={'ordering': ['-start_time'], 'verbose_name': 'Event', 'verbose_name_plural': 'Events'},
        ),
        migrations.AlterModelOptions(
            name='fileupload',
            options={'ordering': ['-created_at'], 'verbose_name': 'File Upload', 'verbose_name_plural': 'File Uploads'},
        ),
        migrations.AlterModelOptions(
            name='jobapplication',
            options={'ordering': ['-created_at'], 'verbose_name': 'Job Application', 'verbose_name_plural': 'Job Applications'},
        ),
        migrations.AlterModelOptions(
            name='notification',
            options={'ordering': ['-created_at'], 'verbose_name': 'Notification', 'verbose_name_plural': 'Notifications'},
        ),
        migrations.AlterModelOptions(
            name='post',
            options={'ordering': ['-published_at', '-created_at'], 'verbose_name': 'Blog Post', 'verbose_name_plural': 'Blog Posts'},
        ),
        migrations.AlterModelOptions(
            name='siteconfig',
            options={'verbose_name': 'Site Configuration', 'verbose_name_plural': 'Site Configuration'},
        ),
        migrations.AlterModelOptions(
            name='testimonial',
            options={'ordering': ['-created_at'], 'verbose_name': 'Testimonial', 'verbose_name_plural': 'Testimonials'},
        ),
        migrations.AlterModelOptions(
            name='trainingprogram',
            options={'ordering': ['-created_at'], 'verbose_name': 'Training Program', 'verbose_name_plural': 'Training Programs'},
        ),
        migrations.AlterModelOptions(
            name='trainingregistration',
            options={'ordering': ['-created_at'], 'verbose_name': 'Training Registration', 'verbose_name_plural': 'Training Registrations'},
        ),
        migrations.AddField(
            model_name='assistantfeedback',
            name='improvements_suggested',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='assistantfeedback',
            name='rating',
            field=models.PositiveSmallIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AddField(
            model_name='assistantfeedback',
            name='would_use_again',
            field=models.BooleanField(null=True),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='author',
            field=models.CharField(default='SeovoSolutions Team', max_length=100),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='complexity',
            field=models.CharField(choices=[('beginner', 'Beginner'), ('intermediate', 'Intermediate'), ('advanced', 'Advanced')], default='intermediate', max_length=20),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='dataset_size',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='featured',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='last_viewed_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='meta_description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='meta_title',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='methodology',
            field=models.CharField(blank=True, default='', max_length=200),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='post_type',
            field=models.CharField(choices=[('data_insight', 'Data Insight'), ('tutorial', 'Tutorial'), ('case_study', 'Case Study'), ('news', 'News'), ('announcement', 'Announcement'), ('thought_leadership', 'Thought Leadership')], default='data_insight', max_length=50),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='read_time',
            field=models.PositiveIntegerField(default=5, help_text='Estimated reading time in minutes'),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='slug',
            field=models.SlugField(blank=True, unique=True),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='social_platforms',
            field=models.JSONField(blank=True, default=list, help_text='Platforms where post was shared'),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='tags',
            field=models.JSONField(blank=True, default=list),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='tools',
            field=models.JSONField(blank=True, default=list, help_text='Tools/technologies used'),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='updated_at',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='view_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='contact',
            name='archived',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='contact',
            name='archived_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='contact',
            name='company',
            field=models.CharField(blank=True, default='', max_length=150),
        ),
        migrations.AddField(
            model_name='contact',
            name='contact_type',
            field=models.CharField(choices=[('general', 'General Inquiry'), ('support', 'Technical Support'), ('partnership', 'Partnership'), ('career', 'Career Opportunity'), ('training', 'Training Inquiry'), ('other', 'Other')], default='general', max_length=50),
        ),
        migrations.AddField(
            model_name='contact',
            name='phone',
            field=models.CharField(blank=True, default='', max_length=20),
        ),
        migrations.AddField(
            model_name='contact',
            name='priority',
            field=models.CharField(choices=[('low', 'Low'), ('medium', 'Medium'), ('high', 'High')], default='medium', max_length=20),
        ),
        migrations.AddField(
            model_name='contact',
            name='responded_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='contact',
            name='response_notes',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='response_time',
            field=models.FloatField(default=0, help_text='Response time in seconds'),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='session_id',
            field=models.CharField(blank=True, default='', help_text='Unique session identifier', max_length=100),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='user_satisfaction',
            field=models.IntegerField(blank=True, help_text='User satisfaction rating 1-5', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AddField(
            model_name='document',
            name='is_active',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='document',
            name='language',
            field=models.CharField(default='en', max_length=10),
        ),
        migrations.AddField(
            model_name='document',
            name='total_chunks',
            field=models.IntegerField(default=1),
        ),
        migrations.AddField(
            model_name='event',
            name='current_registrations',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='event',
            name='event_type',
            field=models.CharField(choices=[('workshop', 'Workshop'), ('webinar', 'Webinar'), ('conference', 'Conference'), ('seminar', 'Seminar'), ('networking', 'Networking Event'), ('training', 'Training Session')], default='workshop', max_length=50),
        ),
        migrations.AddField(
            model_name='event',
            name='featured',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='event',
            name='is_hybrid',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='event',
            name='price',
            field=models.DecimalField(decimal_places=2, default=0.0, max_digits=10),
        ),
        migrations.AddField(
            model_name='event',
            name='published',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='event',
            name='registration_open',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='event',
            name='short_description',
            field=models.TextField(blank=True, default='', max_length=300),
        ),
        migrations.AddField(
            model_name='event',
            name='virtual_link',
            field=models.URLField(blank=True, default='', help_text='Link for virtual events'),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='file_type',
            field=models.CharField(blank=True, default='', max_length=50),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='is_public',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='title',
            field=models.CharField(blank=True, default='Untitled File', max_length=255),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='archived',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='archived_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='interview_date',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='linkedin_url',
            field=models.URLField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='notes',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='phone',
            field=models.CharField(blank=True, default='', max_length=20),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='portfolio_url',
            field=models.URLField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='rating',
            field=models.PositiveSmallIntegerField(default=0, help_text='Rating from 0 to 5', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AddField(
            model_name='notification',
            name='action_url',
            field=models.URLField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='notification',
            name='expires_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='notification',
            name='message',
            field=models.TextField(default='No message content'),
        ),
        migrations.AddField(
            model_name='notification',
            name='priority',
            field=models.CharField(choices=[('low', 'Low'), ('medium', 'Medium'), ('high', 'High'), ('urgent', 'Urgent')], default='medium', max_length=20),
        ),
        migrations.AddField(
            model_name='notification',
            name='read_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='notification',
            name='title',
            field=models.CharField(default='Notification', max_length=200),
        ),
        migrations.AddField(
            model_name='post',
            name='excerpt',
            field=models.TextField(blank=True, default='', max_length=500),
        ),
        migrations.AddField(
            model_name='post',
            name='featured',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='post',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='posts/%Y/%m/%d/'),
        ),
        migrations.AddField(
            model_name='post',
            name='post_type',
            field=models.CharField(choices=[('blog', 'Blog Post'), ('news', 'News'), ('announcement', 'Announcement'), ('tutorial', 'Tutorial'), ('case_study', 'Case Study')], default='blog', max_length=50),
        ),
        migrations.AddField(
            model_name='post',
            name='published_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='post',
            name='reading_time',
            field=models.PositiveIntegerField(default=5, help_text='Estimated reading time in minutes'),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='address',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='analytics_code',
            field=models.TextField(blank=True, default='', help_text='Google Analytics or other tracking code'),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='contact_email',
            field=models.EmailField(default='admin@seovosolutions.com', max_length=254),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='phone_number',
            field=models.CharField(blank=True, default='', max_length=20),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='social_links',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='support_email',
            field=models.EmailField(default='support@seovosolutions.com', max_length=254),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='featured',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='testimonials/'),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='position',
            field=models.CharField(blank=True, default='', max_length=150),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='project_type',
            field=models.CharField(blank=True, default='', help_text='e.g., SEO, Training, Consulting', max_length=100),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='website',
            field=models.URLField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='current_enrollment',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='curriculum',
            field=models.JSONField(blank=True, default=list),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='discount_price',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='duration',
            field=models.CharField(blank=True, default='', help_text='e.g., 6 weeks, 2 days', max_length=100),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='featured',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='training/programs/'),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='instructor_bio',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='learning_objectives',
            field=models.JSONField(blank=True, default=list),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='level',
            field=models.CharField(choices=[('beginner', 'Beginner'), ('intermediate', 'Intermediate'), ('advanced', 'Advanced'), ('all', 'All Levels')], default='all', max_length=50),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='prerequisites',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='program_type',
            field=models.CharField(choices=[('workshop', 'Workshop'), ('certification', 'Certification'), ('webinar', 'Webinar'), ('bootcamp', 'Bootcamp'), ('course', 'Course')], default='course', max_length=50),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='short_description',
            field=models.TextField(blank=True, default='', max_length=300),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='amount_paid',
            field=models.DecimalField(decimal_places=2, default=0.0, max_digits=10),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='company',
            field=models.CharField(blank=True, default='', max_length=150),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='contacted',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='contacted_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='phone',
            field=models.CharField(blank=True, default='', max_length=20),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='referral_source',
            field=models.CharField(blank=True, default='', max_length=200),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='special_requirements',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='status',
            field=models.CharField(choices=[('pending', 'Pending'), ('confirmed', 'Confirmed'), ('waitlisted', 'Waitlisted'), ('cancelled', 'Cancelled'), ('completed', 'Completed')], default='pending', max_length=50),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='comment',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='caption',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='title',
            field=models.CharField(default='Untitled Blovion Post', max_length=255),
        ),
        migrations.AlterField(
            model_name='contact',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='contact',
            name='email',
            field=models.EmailField(default='no-email@example.com', max_length=254),
        ),
        migrations.AlterField(
            model_name='contact',
            name='message',
            field=models.TextField(default='No message provided'),
        ),
        migrations.AlterField(
            model_name='contact',
            name='name',
            field=models.CharField(default='Anonymous', max_length=150),
        ),
        migrations.AlterField(
            model_name='contact',
            name='subject',
            field=models.CharField(blank=True, default='No Subject', max_length=200),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='bot_reply',
            field=models.TextField(default='No bot reply'),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='intent',
            field=models.CharField(blank=True, default='', max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='user_identifier',
            field=models.CharField(blank=True, default='anonymous', max_length=200, null=True),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='user_message',
            field=models.TextField(default='No user message'),
        ),
        migrations.AlterField(
            model_name='document',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='document',
            name='source',
            field=models.CharField(choices=[('post', 'Post'), ('event', 'Event'), ('training', 'Training'), ('file', 'File'), ('manual', 'Manual'), ('testimonial', 'Testimonial'), ('blovion', 'Blovion Post')], default='manual', max_length=50),
        ),
        migrations.AlterField(
            model_name='document',
            name='source_id',
            field=models.CharField(blank=True, default='', max_length=200, null=True),
        ),
        migrations.AlterField(
            model_name='document',
            name='text',
            field=models.TextField(default='No content'),
        ),
        migrations.AlterField(
            model_name='document',
            name='title',
            field=models.CharField(blank=True, default='Untitled Document', max_length=400),
        ),
        migrations.AlterField(
            model_name='event',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='event',
            name='description',
            field=models.TextField(default='Event description not available'),
        ),
        migrations.AlterField(
            model_name='event',
            name='location',
            field=models.CharField(blank=True, default='TBA', max_length=255),
        ),
        migrations.AlterField(
            model_name='event',
            name='meta_description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='event',
            name='meta_title',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AlterField(
            model_name='event',
            name='start_time',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='event',
            name='title',
            field=models.CharField(default='Untitled Event', max_length=200),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='category',
            field=models.CharField(choices=[('document', 'Document'), ('image', 'Image'), ('video', 'Video'), ('audio', 'Audio'), ('archive', 'Archive'), ('other', 'Other')], default='document', max_length=100),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='cover_letter',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='email',
            field=models.EmailField(default='no-email@example.com', max_length=254),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='full_name',
            field=models.CharField(default='Anonymous Applicant', max_length=150),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='position',
            field=models.CharField(default='Unspecified Position', max_length=200),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='status',
            field=models.CharField(choices=[('pending', 'Pending Review'), ('reviewed', 'Reviewed'), ('shortlisted', 'Shortlisted'), ('interview', 'Interview Scheduled'), ('rejected', 'Rejected'), ('hired', 'Hired')], default='pending', max_length=50),
        ),
        migrations.AlterField(
            model_name='notification',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='notification',
            name='type',
            field=models.CharField(choices=[('system', 'System Notification'), ('user', 'User Message'), ('alert', 'Alert'), ('reminder', 'Reminder'), ('update', 'Update')], default='system', max_length=50),
        ),
        migrations.AlterField(
            model_name='post',
            name='content',
            field=models.TextField(default='Content not available'),
        ),
        migrations.AlterField(
            model_name='post',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='post',
            name='meta_description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='post',
            name='meta_title',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AlterField(
            model_name='post',
            name='title',
            field=models.CharField(default='Untitled Post', max_length=250),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='company',
            field=models.CharField(blank=True, default='', max_length=150),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='message',
            field=models.TextField(default='No testimonial message'),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='name',
            field=models.CharField(default='Anonymous', max_length=150),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='description',
            field=models.TextField(default='Description not available'),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='instructor',
            field=models.CharField(blank=True, default='TBA', max_length=150),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='meta_description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='meta_title',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='title',
            field=models.CharField(default='Untitled Training Program', max_length=200),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='email',
            field=models.EmailField(default='no-email@example.com', max_length=254),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='full_name',
            field=models.CharField(default='Anonymous User', max_length=150),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='notes',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='payment_status',
            field=models.CharField(choices=[('pending', 'Pending'), ('paid', 'Paid'), ('partial', 'Partial Payment'), ('refunded', 'Refunded'), ('cancelled', 'Cancelled')], default='pending', max_length=50),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='categories',
            field=models.ManyToManyField(blank=True, to='website.category'),
        ),
        migrations.AddField(
            model_name='post',
            name='categories',
            field=models.ManyToManyField(blank=True, to='website.category'),
        ),
        migrations.CreateModel(
            name='PageView',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page_url', models.CharField(default='/', max_length=500)),
                ('page_title', models.CharField(blank=True, default='', max_length=200)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('user_agent', models.TextField(blank=True, default='')),
                ('referrer', models.CharField(blank=True, default='', max_length=500)),
                ('session_id', models.CharField(blank=True, default='', max_length=100)),
                ('duration', models.PositiveIntegerField(default=0, help_text='Time spent on page in seconds')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Page View',
                'verbose_name_plural': 'Page Views',
                'ordering': ['-created_at'],
            },
        ),
    ]
