# Generated by Django 5.2.7 on 2025-11-09 09:51

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('website', '0005_category_systemmetric_and_more'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='category',
            options={'ordering': ['order', 'name'], 'verbose_name_plural': 'Categories'},
        ),
        migrations.AlterModelOptions(
            name='testimonial',
            options={'ordering': ['display_order', '-created_at'], 'verbose_name': 'Testimonial', 'verbose_name_plural': 'Testimonials'},
        ),
        migrations.AddField(
            model_name='assistantfeedback',
            name='metadata',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='assistantfeedback',
            name='response_accuracy',
            field=models.PositiveSmallIntegerField(blank=True, help_text='Accuracy rating 1-5', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AddField(
            model_name='assistantfeedback',
            name='response_speed',
            field=models.PositiveSmallIntegerField(blank=True, help_text='Speed rating 1-5', null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='category',
            field=models.CharField(blank=True, db_index=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='comment_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='content',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='like_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='meta_keywords',
            field=models.CharField(blank=True, default='', max_length=500),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='metadata',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='scheduled_at',
            field=models.DateTimeField(blank=True, help_text='Schedule publication for future', null=True),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='share_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='social_links',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('published', 'Published'), ('scheduled', 'Scheduled'), ('archived', 'Archived')], db_index=True, default='draft', max_length=20),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='video_thumbnail',
            field=models.ImageField(blank=True, null=True, upload_to='blovion/thumbnails/%Y/%m/'),
        ),
        migrations.AddField(
            model_name='blovionpost',
            name='word_count',
            field=models.PositiveIntegerField(default=0, editable=False),
        ),
        migrations.AddField(
            model_name='category',
            name='order',
            field=models.PositiveIntegerField(default=0, help_text='Display order'),
        ),
        migrations.AddField(
            model_name='category',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='website.category'),
        ),
        migrations.AddField(
            model_name='category',
            name='post_count',
            field=models.PositiveIntegerField(default=0, editable=False),
        ),
        migrations.AddField(
            model_name='contact',
            name='archived_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='archived_%(class)ss', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='contact',
            name='budget',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='contact',
            name='interest_area',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='contact',
            name='ip_address',
            field=models.GenericIPAddressField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='contact',
            name='newsletter_optin',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='contact',
            name='responded_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='responded_contacts', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='contact',
            name='source',
            field=models.CharField(blank=True, db_index=True, default='website', max_length=100),
        ),
        migrations.AddField(
            model_name='contact',
            name='timeframe',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='contact',
            name='user_agent',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='cost',
            field=models.DecimalField(decimal_places=6, default=0.0, help_text='Cost of this interaction', max_digits=10),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='language',
            field=models.CharField(db_index=True, default='en', max_length=10),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='service_used',
            field=models.CharField(blank=True, db_index=True, default='', max_length=50),
        ),
        migrations.AddField(
            model_name='conversationlog',
            name='tokens_used',
            field=models.PositiveIntegerField(default=0, help_text='Total tokens used in this interaction'),
        ),
        migrations.AddField(
            model_name='document',
            name='content_hash',
            field=models.CharField(blank=True, default='', help_text='SHA256 hash of content for deduplication', max_length=64),
        ),
        migrations.AddField(
            model_name='document',
            name='description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='document',
            name='metadata',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='document',
            name='token_count',
            field=models.PositiveIntegerField(default=0, help_text='Approximate token count for AI processing'),
        ),
        migrations.AddField(
            model_name='document',
            name='url',
            field=models.URLField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='event',
            name='currency',
            field=models.CharField(default='USD', max_length=10),
        ),
        migrations.AddField(
            model_name='event',
            name='detailed_description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='event',
            name='meta_keywords',
            field=models.CharField(blank=True, default='', max_length=500),
        ),
        migrations.AddField(
            model_name='event',
            name='registration_deadline',
            field=models.DateTimeField(blank=True, db_index=True, null=True),
        ),
        migrations.AddField(
            model_name='event',
            name='registration_required',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='event',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('scheduled', 'Scheduled'), ('ongoing', 'Ongoing'), ('completed', 'Completed'), ('cancelled', 'Cancelled')], db_index=True, default='scheduled', max_length=20),
        ),
        migrations.AddField(
            model_name='event',
            name='timezone',
            field=models.CharField(default='UTC', max_length=50),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='access_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='file_name',
            field=models.CharField(blank=True, default='', max_length=255),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='file_size',
            field=models.PositiveBigIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='last_accessed',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='fileupload',
            name='metadata',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='application_code',
            field=models.CharField(blank=True, max_length=20, null=True, unique=True),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='archived_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='archived_%(class)ss', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='available_from',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='current_company',
            field=models.CharField(blank=True, default='', max_length=150),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='github_url',
            field=models.URLField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='notice_period',
            field=models.CharField(blank=True, default='', max_length=50),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='salary_expectation',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='skills',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='source',
            field=models.CharField(blank=True, db_index=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='jobapplication',
            name='years_experience',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='notification',
            name='action_text',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='notification',
            name='icon',
            field=models.CharField(blank=True, default='', help_text='Icon name for UI display', max_length=50),
        ),
        migrations.AddField(
            model_name='pageview',
            name='browser',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='pageview',
            name='city',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='pageview',
            name='country',
            field=models.CharField(blank=True, db_index=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='pageview',
            name='device_type',
            field=models.CharField(blank=True, db_index=True, default='', max_length=50),
        ),
        migrations.AddField(
            model_name='pageview',
            name='is_bounce',
            field=models.BooleanField(default=True, help_text='Whether the user left without further interaction'),
        ),
        migrations.AddField(
            model_name='pageview',
            name='operating_system',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='pageview',
            name='timestamp',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='pageview',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AddField(
            model_name='pageview',
            name='url',
            field=models.CharField(db_index=True, default='/', max_length=500),
        ),
        migrations.AddField(
            model_name='post',
            name='comment_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='post',
            name='cover_image',
            field=models.ImageField(blank=True, null=True, upload_to='posts/covers/%Y/%m/'),
        ),
        migrations.AddField(
            model_name='post',
            name='language',
            field=models.CharField(db_index=True, default='en', max_length=10),
        ),
        migrations.AddField(
            model_name='post',
            name='like_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='post',
            name='meta_keywords',
            field=models.CharField(blank=True, default='', max_length=500),
        ),
        migrations.AddField(
            model_name='post',
            name='pinned',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AddField(
            model_name='post',
            name='scheduled_at',
            field=models.DateTimeField(blank=True, help_text='Schedule publication for future', null=True),
        ),
        migrations.AddField(
            model_name='post',
            name='share_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='post',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('published', 'Published'), ('scheduled', 'Scheduled'), ('archived', 'Archived')], db_index=True, default='draft', max_length=20),
        ),
        migrations.AddField(
            model_name='post',
            name='word_count',
            field=models.PositiveIntegerField(default=0, editable=False),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='cache_duration',
            field=models.PositiveIntegerField(default=300, help_text='Cache duration in seconds'),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='data_type',
            field=models.CharField(choices=[('string', 'String'), ('integer', 'Integer'), ('boolean', 'Boolean'), ('json', 'JSON'), ('text', 'Text'), ('email', 'Email'), ('url', 'URL')], default='string', max_length=20),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='is_public',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='key',
            field=models.CharField(db_index=True, default='main', max_length=100, unique=True),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AddField(
            model_name='siteconfig',
            name='value',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='systemmetric',
            name='category',
            field=models.CharField(choices=[('performance', 'Performance'), ('usage', 'Usage'), ('error', 'Error'), ('business', 'Business'), ('system', 'System'), ('custom', 'Custom')], db_index=True, default='custom', max_length=50),
        ),
        migrations.AddField(
            model_name='systemmetric',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='systemmetric',
            name='timestamp',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='systemmetric',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='display_order',
            field=models.PositiveIntegerField(default=0, help_text='Order in which testimonials are displayed'),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='email',
            field=models.EmailField(blank=True, default='', max_length=254),
        ),
        migrations.AddField(
            model_name='testimonial',
            name='location',
            field=models.CharField(blank=True, default='', max_length=100),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='career_support',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='certification',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='cover_image',
            field=models.ImageField(blank=True, null=True, upload_to='training/covers/%Y/%m/'),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='currency',
            field=models.CharField(default='USD', max_length=10),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='detailed_description',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='difficulty_score',
            field=models.PositiveSmallIntegerField(default=3, help_text='Difficulty level from 1 (easiest) to 5 (hardest)', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='duration_weeks',
            field=models.PositiveIntegerField(default=12, help_text='Duration in weeks'),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='hours_per_week',
            field=models.PositiveIntegerField(default=10, help_text='Hours per week'),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='language',
            field=models.CharField(db_index=True, default='en', max_length=10),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='meta_keywords',
            field=models.CharField(blank=True, default='', max_length=500),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='objectives',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='registration_deadline',
            field=models.DateField(blank=True, db_index=True, null=True),
        ),
        migrations.AddField(
            model_name='trainingprogram',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('published', 'Published'), ('cancelled', 'Cancelled'), ('completed', 'Completed')], db_index=True, default='draft', max_length=20),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='admin_notes',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='background',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='experience_level',
            field=models.CharField(blank=True, choices=[('beginner', 'Beginner'), ('intermediate', 'Intermediate'), ('advanced', 'Advanced')], default='', max_length=20),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='learning_goals',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='metadata',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='payment_method',
            field=models.CharField(blank=True, default='', max_length=50),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='preferred_schedule',
            field=models.CharField(blank=True, choices=[('weekdays', 'Weekdays'), ('weekends', 'Weekends'), ('evenings', 'Evenings'), ('flexible', 'Flexible'), ('intensive', 'Intensive Bootcamp')], default='', max_length=20),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='questions',
            field=models.TextField(blank=True, default=''),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='registration_code',
            field=models.CharField(blank=True, max_length=20, null=True, unique=True),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='source',
            field=models.CharField(db_index=True, default='website', max_length=100),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='submission_date',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='trainingregistration',
            name='time_commitment',
            field=models.CharField(blank=True, default='', max_length=50),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='conversation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='feedbacks', to='website.conversationlog'),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='helpful',
            field=models.BooleanField(db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='rating',
            field=models.PositiveSmallIntegerField(blank=True, db_index=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='assistantfeedback',
            name='would_use_again',
            field=models.BooleanField(db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='categories',
            field=models.ManyToManyField(blank=True, related_name='blovion_posts', to='website.category'),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='complexity',
            field=models.CharField(choices=[('beginner', 'Beginner'), ('intermediate', 'Intermediate'), ('advanced', 'Advanced')], db_index=True, default='intermediate', max_length=20),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='featured',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='meta_description',
            field=models.TextField(blank=True, default='', max_length=500),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='post_type',
            field=models.CharField(choices=[('data_insight', 'Data Insight'), ('tutorial', 'Tutorial'), ('case_study', 'Case Study'), ('news', 'News'), ('announcement', 'Announcement'), ('thought_leadership', 'Thought Leadership'), ('analysis', 'Analysis'), ('trend', 'Trend Report')], db_index=True, default='data_insight', max_length=50),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='published',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='published_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='slug',
            field=models.SlugField(blank=True, max_length=300, unique=True),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='blovionpost',
            name='view_count',
            field=models.PositiveIntegerField(db_index=True, default=0),
        ),
        migrations.AlterField(
            model_name='category',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='category',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='category',
            name='slug',
            field=models.SlugField(max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name='category',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='contact',
            name='archived',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='contact',
            name='contact_type',
            field=models.CharField(choices=[('general', 'General Inquiry'), ('support', 'Technical Support'), ('partnership', 'Partnership'), ('career', 'Career Opportunity'), ('training', 'Training Inquiry'), ('other', 'Other')], db_index=True, default='general', max_length=50),
        ),
        migrations.AlterField(
            model_name='contact',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='contact',
            name='email',
            field=models.EmailField(db_index=True, default='no-email@example.com', max_length=254),
        ),
        migrations.AlterField(
            model_name='contact',
            name='priority',
            field=models.CharField(choices=[('low', 'Low'), ('medium', 'Medium'), ('high', 'High'), ('urgent', 'Urgent')], db_index=True, default='medium', max_length=20),
        ),
        migrations.AlterField(
            model_name='contact',
            name='responded',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='contact',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='intent',
            field=models.CharField(blank=True, db_index=True, default='', max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='session_id',
            field=models.CharField(blank=True, db_index=True, default='', help_text='Unique session identifier', max_length=100),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='conversations', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='conversationlog',
            name='user_identifier',
            field=models.CharField(blank=True, db_index=True, default='anonymous', max_length=200, null=True),
        ),
        migrations.AlterField(
            model_name='document',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='document',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='document',
            name='language',
            field=models.CharField(db_index=True, default='en', max_length=10),
        ),
        migrations.AlterField(
            model_name='document',
            name='source',
            field=models.CharField(choices=[('post', 'Post'), ('event', 'Event'), ('training', 'Training'), ('file', 'File'), ('manual', 'Manual'), ('testimonial', 'Testimonial'), ('blovion', 'Blovion Post'), ('page', 'Page'), ('faq', 'FAQ')], db_index=True, default='manual', max_length=50),
        ),
        migrations.AlterField(
            model_name='document',
            name='source_id',
            field=models.CharField(blank=True, db_index=True, default='', max_length=200, null=True),
        ),
        migrations.AlterField(
            model_name='document',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='event',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='event',
            name='end_time',
            field=models.DateTimeField(blank=True, db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='event',
            name='event_type',
            field=models.CharField(choices=[('workshop', 'Workshop'), ('webinar', 'Webinar'), ('conference', 'Conference'), ('seminar', 'Seminar'), ('networking', 'Networking Event'), ('training', 'Training Session'), ('meetup', 'Community Meetup')], db_index=True, default='workshop', max_length=50),
        ),
        migrations.AlterField(
            model_name='event',
            name='featured',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='event',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='events/%Y/%m/'),
        ),
        migrations.AlterField(
            model_name='event',
            name='is_virtual',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='event',
            name='meta_description',
            field=models.TextField(blank=True, default='', max_length=500),
        ),
        migrations.AlterField(
            model_name='event',
            name='organizer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='organized_events', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='event',
            name='price',
            field=models.DecimalField(db_index=True, decimal_places=2, default=0.0, max_digits=10),
        ),
        migrations.AlterField(
            model_name='event',
            name='published',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='event',
            name='registration_open',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='event',
            name='start_time',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='event',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='event',
            name='view_count',
            field=models.PositiveIntegerField(db_index=True, default=0),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='category',
            field=models.CharField(choices=[('document', 'Document'), ('image', 'Image'), ('video', 'Video'), ('audio', 'Audio'), ('archive', 'Archive'), ('other', 'Other')], db_index=True, default='document', max_length=100),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='file_type',
            field=models.CharField(blank=True, db_index=True, default='', max_length=50),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='is_public',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='size_kb',
            field=models.FloatField(db_index=True, default=0),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='fileupload',
            name='uploaded_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='uploaded_files', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='archived',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='email',
            field=models.EmailField(db_index=True, default='no-email@example.com', max_length=254),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='position',
            field=models.CharField(db_index=True, default='Unspecified Position', max_length=200),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='status',
            field=models.CharField(choices=[('pending', 'Pending Review'), ('reviewed', 'Reviewed'), ('shortlisted', 'Shortlisted'), ('interview', 'Interview Scheduled'), ('rejected', 'Rejected'), ('hired', 'Hired')], db_index=True, default='pending', max_length=50),
        ),
        migrations.AlterField(
            model_name='jobapplication',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='notification',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='notification',
            name='expires_at',
            field=models.DateTimeField(blank=True, db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='notification',
            name='payload',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='notification',
            name='priority',
            field=models.CharField(choices=[('low', 'Low'), ('medium', 'Medium'), ('high', 'High'), ('urgent', 'Urgent')], db_index=True, default='medium', max_length=20),
        ),
        migrations.AlterField(
            model_name='notification',
            name='read',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='notification',
            name='recipient',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notifications', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='notification',
            name='type',
            field=models.CharField(choices=[('system', 'System Notification'), ('user', 'User Message'), ('alert', 'Alert'), ('reminder', 'Reminder'), ('update', 'Update'), ('success', 'Success'), ('warning', 'Warning'), ('error', 'Error')], db_index=True, default='system', max_length=50),
        ),
        migrations.AlterField(
            model_name='notification',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='pageview',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='pageview',
            name='ip_address',
            field=models.GenericIPAddressField(blank=True, db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='pageview',
            name='page_url',
            field=models.CharField(db_index=True, default='/', max_length=500),
        ),
        migrations.AlterField(
            model_name='pageview',
            name='session_id',
            field=models.CharField(blank=True, db_index=True, default='', max_length=100),
        ),
        migrations.AlterField(
            model_name='pageview',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='page_views', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='post',
            name='attachments',
            field=models.ManyToManyField(blank=True, related_name='posts', to='website.fileupload'),
        ),
        migrations.AlterField(
            model_name='post',
            name='author',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='posts', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='post',
            name='categories',
            field=models.ManyToManyField(blank=True, related_name='posts', to='website.category'),
        ),
        migrations.AlterField(
            model_name='post',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='post',
            name='featured',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='post',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='posts/%Y/%m/'),
        ),
        migrations.AlterField(
            model_name='post',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='post',
            name='meta_description',
            field=models.TextField(blank=True, default='', max_length=500),
        ),
        migrations.AlterField(
            model_name='post',
            name='post_type',
            field=models.CharField(choices=[('blog', 'Blog Post'), ('news', 'News'), ('announcement', 'Announcement'), ('tutorial', 'Tutorial'), ('case_study', 'Case Study'), ('guide', 'Guide')], db_index=True, default='blog', max_length=50),
        ),
        migrations.AlterField(
            model_name='post',
            name='published',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='post',
            name='published_at',
            field=models.DateTimeField(blank=True, db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='post',
            name='slug',
            field=models.SlugField(blank=True, max_length=300, unique=True),
        ),
        migrations.AlterField(
            model_name='post',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='post',
            name='view_count',
            field=models.PositiveIntegerField(db_index=True, default=0),
        ),
        migrations.AlterField(
            model_name='siteconfig',
            name='maintenance_mode',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='systemmetric',
            name='metric_type',
            field=models.CharField(db_index=True, default='unknown', max_length=100),
        ),
        migrations.AlterField(
            model_name='systemmetric',
            name='recorded_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='approved',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='featured',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='testimonials/%Y/%m/'),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='rating',
            field=models.PositiveSmallIntegerField(db_index=True, default=5, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)]),
        ),
        migrations.AlterField(
            model_name='testimonial',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='end_date',
            field=models.DateField(blank=True, db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='featured',
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='image',
            field=models.ImageField(blank=True, null=True, upload_to='training/programs/%Y/%m/'),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='is_active',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='level',
            field=models.CharField(choices=[('beginner', 'Beginner'), ('intermediate', 'Intermediate'), ('advanced', 'Advanced'), ('all', 'All Levels')], db_index=True, default='all', max_length=50),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='meta_description',
            field=models.TextField(blank=True, default='', max_length=500),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='price',
            field=models.DecimalField(db_index=True, decimal_places=2, default=0.0, max_digits=10),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='program_type',
            field=models.CharField(choices=[('workshop', 'Workshop'), ('certification', 'Certification'), ('webinar', 'Webinar'), ('bootcamp', 'Bootcamp'), ('course', 'Course')], db_index=True, default='course', max_length=50),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='registration_open',
            field=models.BooleanField(db_index=True, default=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='slug',
            field=models.SlugField(blank=True, max_length=300, unique=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='start_date',
            field=models.DateField(blank=True, db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='trainingprogram',
            name='view_count',
            field=models.PositiveIntegerField(db_index=True, default=0),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='created_at',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='email',
            field=models.EmailField(db_index=True, default='no-email@example.com', max_length=254),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='payment_status',
            field=models.CharField(choices=[('pending', 'Pending'), ('paid', 'Paid'), ('partial', 'Partial Payment'), ('refunded', 'Refunded'), ('cancelled', 'Cancelled')], db_index=True, default='pending', max_length=50),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='status',
            field=models.CharField(choices=[('pending', 'Pending'), ('confirmed', 'Confirmed'), ('waitlisted', 'Waitlisted'), ('cancelled', 'Cancelled'), ('completed', 'Completed')], db_index=True, default='pending', max_length=50),
        ),
        migrations.AlterField(
            model_name='trainingregistration',
            name='updated_at',
            field=models.DateTimeField(auto_now=True, db_index=True),
        ),
        migrations.AlterUniqueTogether(
            name='document',
            unique_together={('source', 'source_id', 'chunk_index')},
        ),
        migrations.AddIndex(
            model_name='assistantfeedback',
            index=models.Index(fields=['helpful', 'rating'], name='website_ass_helpful_ab0e53_idx'),
        ),
        migrations.AddIndex(
            model_name='assistantfeedback',
            index=models.Index(fields=['conversation', 'created_at'], name='website_ass_convers_c4ebdb_idx'),
        ),
        migrations.AddIndex(
            model_name='blovionpost',
            index=models.Index(fields=['post_type', 'status'], name='website_blo_post_ty_2c4632_idx'),
        ),
        migrations.AddIndex(
            model_name='blovionpost',
            index=models.Index(fields=['complexity', 'featured'], name='website_blo_complex_aeebf7_idx'),
        ),
        migrations.AddIndex(
            model_name='blovionpost',
            index=models.Index(fields=['published_at', 'published'], name='website_blo_publish_9582f5_idx'),
        ),
        migrations.AddIndex(
            model_name='category',
            index=models.Index(fields=['is_active', 'parent'], name='website_cat_is_acti_01b865_idx'),
        ),
        migrations.AddIndex(
            model_name='contact',
            index=models.Index(fields=['email', 'created_at'], name='website_con_email_748751_idx'),
        ),
        migrations.AddIndex(
            model_name='contact',
            index=models.Index(fields=['contact_type', 'responded'], name='website_con_contact_b54fe4_idx'),
        ),
        migrations.AddIndex(
            model_name='conversationlog',
            index=models.Index(fields=['session_id', 'created_at'], name='website_con_session_ae51c2_idx'),
        ),
        migrations.AddIndex(
            model_name='conversationlog',
            index=models.Index(fields=['user_identifier', 'created_at'], name='website_con_user_id_e27ca4_idx'),
        ),
        migrations.AddIndex(
            model_name='conversationlog',
            index=models.Index(fields=['intent', 'confidence'], name='website_con_intent_1aeb18_idx'),
        ),
        migrations.AddIndex(
            model_name='document',
            index=models.Index(fields=['source', 'source_id'], name='website_doc_source_4d1924_idx'),
        ),
        migrations.AddIndex(
            model_name='document',
            index=models.Index(fields=['is_active', 'language'], name='website_doc_is_acti_340dc6_idx'),
        ),
        migrations.AddIndex(
            model_name='document',
            index=models.Index(fields=['content_hash'], name='website_doc_content_822c45_idx'),
        ),
        migrations.AddIndex(
            model_name='event',
            index=models.Index(fields=['event_type', 'status'], name='website_eve_event_t_0a3490_idx'),
        ),
        migrations.AddIndex(
            model_name='event',
            index=models.Index(fields=['start_time', 'end_time'], name='website_eve_start_t_0b1029_idx'),
        ),
        migrations.AddIndex(
            model_name='event',
            index=models.Index(fields=['is_virtual', 'published'], name='website_eve_is_virt_72e7c7_idx'),
        ),
        migrations.AddIndex(
            model_name='fileupload',
            index=models.Index(fields=['category', 'file_type'], name='website_fil_categor_7d4afd_idx'),
        ),
        migrations.AddIndex(
            model_name='fileupload',
            index=models.Index(fields=['uploaded_by', 'created_at'], name='website_fil_uploade_1a40fc_idx'),
        ),
        migrations.AddIndex(
            model_name='jobapplication',
            index=models.Index(fields=['position', 'status'], name='website_job_positio_012b08_idx'),
        ),
        migrations.AddIndex(
            model_name='jobapplication',
            index=models.Index(fields=['email', 'created_at'], name='website_job_email_cbe6c1_idx'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=models.Index(fields=['recipient', 'read'], name='website_not_recipie_363074_idx'),
        ),
        migrations.AddIndex(
            model_name='notification',
            index=models.Index(fields=['type', 'priority'], name='website_not_type_7570b3_idx'),
        ),
        migrations.AddIndex(
            model_name='pageview',
            index=models.Index(fields=['timestamp', 'page_url'], name='website_pag_timesta_2bf992_idx'),
        ),
        migrations.AddIndex(
            model_name='pageview',
            index=models.Index(fields=['session_id', 'timestamp'], name='website_pag_session_3a7741_idx'),
        ),
        migrations.AddIndex(
            model_name='pageview',
            index=models.Index(fields=['ip_address', 'created_at'], name='website_pag_ip_addr_6c8551_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['status', 'published_at'], name='website_pos_status_123faa_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['post_type', 'featured'], name='website_pos_post_ty_8d5c4e_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['author', 'created_at'], name='website_pos_author__9df263_idx'),
        ),
        migrations.AddIndex(
            model_name='siteconfig',
            index=models.Index(fields=['key', 'is_public'], name='website_sit_key_3eaf88_idx'),
        ),
        migrations.AddIndex(
            model_name='systemmetric',
            index=models.Index(fields=['metric_type', 'recorded_at'], name='website_sys_metric__bd786f_idx'),
        ),
        migrations.AddIndex(
            model_name='systemmetric',
            index=models.Index(fields=['category', 'timestamp'], name='website_sys_categor_102890_idx'),
        ),
        migrations.AddIndex(
            model_name='testimonial',
            index=models.Index(fields=['approved', 'featured'], name='website_tes_approve_913615_idx'),
        ),
        migrations.AddIndex(
            model_name='testimonial',
            index=models.Index(fields=['rating', 'created_at'], name='website_tes_rating_0eb2d2_idx'),
        ),
        migrations.AddIndex(
            model_name='trainingprogram',
            index=models.Index(fields=['program_type', 'status'], name='website_tra_program_2f57e2_idx'),
        ),
        migrations.AddIndex(
            model_name='trainingprogram',
            index=models.Index(fields=['level', 'featured'], name='website_tra_level_9aeced_idx'),
        ),
        migrations.AddIndex(
            model_name='trainingprogram',
            index=models.Index(fields=['start_date', 'end_date'], name='website_tra_start_d_7d1ebf_idx'),
        ),
        migrations.AddIndex(
            model_name='trainingregistration',
            index=models.Index(fields=['email', 'status'], name='website_tra_email_98a7b7_idx'),
        ),
        migrations.AddIndex(
            model_name='trainingregistration',
            index=models.Index(fields=['program', 'status'], name='website_tra_program_05034e_idx'),
        ),
        migrations.AddIndex(
            model_name='trainingregistration',
            index=models.Index(fields=['registration_code'], name='website_tra_registr_60ad45_idx'),
        ),
    ]
