import logging
import requests
from django.conf import settings

logger = logging.getLogger(__name__)

def post_to_socials(title, caption, image_urls=None, video_url=None):
    """
    Auto-posts content to LinkedIn, Facebook, Instagram, and TikTok.
    """
    try:
        message = f"{title}\n\n{caption or ''}"
        media = image_urls[0] if image_urls else None

        # Example: LinkedIn
        linkedin_token = settings.LINKEDIN_ACCESS_TOKEN
        if linkedin_token:
            requests.post(
                "https://api.linkedin.com/v2/ugcPosts",
                headers={
                    "Authorization": f"Bearer {linkedin_token}",
                    "Content-Type": "application/json"
                },
                json={
                    "author": f"urn:li:person:{settings.LINKEDIN_PERSON_ID}",
                    "lifecycleState": "PUBLISHED",
                    "specificContent": {
                        "com.linkedin.ugc.ShareContent": {
                            "shareCommentary": {"text": message},
                            "shareMediaCategory": "IMAGE" if media else "NONE",
                            "media": [{"status": "READY", "originalUrl": media}] if media else []
                        }
                    },
                    "visibility": {"com.linkedin.ugc.MemberNetworkVisibility": "PUBLIC"}
                }
            )

        # You can add similar logic for Facebook, Instagram, TikTok API using Graph API and TikTok Business API

        logger.info(f"[SocialSync] ✅ Posted '{title}' to social platforms.")
    except Exception as e:
        logger.exception(f"[SocialSync] ❌ Failed to post '{title}': {e}")
